#version 3
#include "colors.inc"
#include "cuerpo.inc"
#include "sol.inc"
#include "casucha.inc"

background { DarkSlateBlue }

plane { y, -.1 pigment { LimeGreen } normal { spotted 1 } finish { phong .4 phong_size 2 } }

//*********************begin earth

object { Casucha }                                                
#declare Empalizada = union {
        box { <-15, -.50, -15>, <-14, 6, 20> }  //lateral derecho
        box { <-15, -.50, 19>, < 20, 6, 20> }   //posterior
        box { <19, -.50, -15>, <20, 6, 20> }    //lateral izquierdo
}

object { Empalizada 
        pigment { color rgb <0.753,0.408,0.384> }
        normal { wrinkles .4 } //scale <3, 2, .2> } //rotate 90*x  }
	finish { phong .1 phong_size 1 }
	}

object { Empalizada 
        pigment { color rgb <0.753,0.408,0.384> }
        normal { wrinkles .4 }
	finish { phong .1 phong_size 1 }
}

//*********************end earth


object { Sol rotate -90*y translate <-20, 8, 4> }
light_source { 0*x  color rgb 1 translate <  -20,  8, 5>  }

#declare Bodimov = union {
                        object { PieIzq pigment { color Med_Purple } translate <0, 2.5, 0> }
                        object { PieDer pigment { color Med_Purple } translate <0, 2.5, 0> }
                        object { Torso pigment { color Very_Light_Purple } translate 2.2*y }
                        object { BrazoIzq pigment { color Med_Purple } translate <.3, 3, 0> }
                        object { BrazoDer pigment { color Med_Purple }translate <-.3, 3, 0> }
                        object { Cabeza translate 3.15*y pigment { color Cyan } }
                        }

#declare spline_clock = clock
#include "to_moon.spl"

object { Bodimov 
        rotate -90*y
        rotate 45*z*clock
        translate <2, 0, 1.5>
        translate spline_pos }


#declare Camarita = camera { location  <6, 3.5,  5> look_at   <0, 3.4,  6> }

#declare luz = light_source { 0*x  color rgb 1 translate <  6,  7, 5> }

camera { Camarita }

object { luz }